/*
 * Decompiled with CFR 0.152.
 */
public class Unit
extends GridObject {
    public static final String SNIPER = "Sniper";
    public static final String ASSAULT = "Assault";
    public static final String SHOTGUNNER = "Shotgunner";
    public static final char NORTH = 'n';
    public static final char SOUTH = 's';
    public static final char EAST = 'e';
    public static final char WEST = 'w';
    public static final int DEF_HEALTH = 20;
    public static final int DEF_MOVES = 2;
    public static final int[] DEF_DAM_SNIP;
    public static final int[] DEF_DAM_ASSA;
    public static final int[] DEF_DAM_SHOT;
    private String unitClass;
    private int unitNum;
    private int health;
    private char direction;
    private int moves;
    private Game unitGame;
    private int[] damage = new int[6];

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 5;
        DEF_DAM_SNIP = nArray;
        DEF_DAM_ASSA = new int[]{1, 2, 4, 4, 2, 1};
        int[] nArray2 = new int[6];
        nArray2[0] = 5;
        nArray2[1] = 3;
        nArray2[2] = 2;
        nArray2[3] = 1;
        nArray2[4] = 1;
        DEF_DAM_SHOT = nArray2;
    }

    public Unit(String uClass, int playerNum, int h, char d, int m, Game g) {
        super("Unit");
        this.isUnit = true;
        this.unitClass = uClass;
        this.unitNum = playerNum;
        this.unitGame = g;
        this.health = h;
        this.direction = d;
        this.moves = m;
        int i = 0;
        while (i < this.damage.length) {
            this.damage = this.unitClass.equals(SNIPER) ? DEF_DAM_SNIP : (this.unitClass.equals(ASSAULT) ? DEF_DAM_ASSA : (this.unitClass.equals(SHOTGUNNER) ? DEF_DAM_SHOT : DEF_DAM_ASSA));
            ++i;
        }
    }

    public void updateDescription() {
        this.description = String.valueOf(this.unitClass) + ", Health: " + this.health + ", Moves: " + this.moves;
    }

    @Override
    public String toShortString() {
        return "Moves: " + this.moves;
    }

    public void turnLeft() {
        switch (this.direction) {
            case 'n': {
                this.direction = (char)119;
                break;
            }
            case 's': {
                this.direction = (char)101;
                break;
            }
            case 'e': {
                this.direction = (char)110;
                break;
            }
            case 'w': {
                this.direction = (char)115;
            }
        }
    }

    public void turnRight() {
        switch (this.direction) {
            case 'n': {
                this.direction = (char)101;
                break;
            }
            case 's': {
                this.direction = (char)119;
                break;
            }
            case 'e': {
                this.direction = (char)115;
                break;
            }
            case 'w': {
                this.direction = (char)110;
            }
        }
    }

    public void turnAround() {
        switch (this.direction) {
            case 'n': {
                this.direction = (char)115;
                break;
            }
            case 's': {
                this.direction = (char)110;
                break;
            }
            case 'e': {
                this.direction = (char)119;
                break;
            }
            case 'w': {
                this.direction = (char)101;
            }
        }
    }

    public boolean moveForward() {
        if (this.moves <= 0) {
            return false;
        }
        boolean moved = this.unitGame.moveUnit(this.unitNum, this.direction);
        if (moved) {
            --this.moves;
        }
        return moved;
    }

    public boolean moveBackward() {
        if (this.moves <= 0) {
            return false;
        }
        boolean moved = this.unitGame.moveUnitBack(this.unitNum, this.direction);
        if (moved) {
            --this.moves;
        }
        return moved;
    }

    public boolean moveLeft() {
        if (this.moves <= 0) {
            return false;
        }
        boolean moved = this.unitGame.moveUnitLeft(this.unitNum, this.direction);
        if (moved) {
            --this.moves;
        }
        return moved;
    }

    public boolean moveRight() {
        if (this.moves <= 0) {
            return false;
        }
        boolean moved = this.unitGame.moveUnitRight(this.unitNum, this.direction);
        if (moved) {
            --this.moves;
        }
        return moved;
    }

    public void shoot() {
        if (this.moves <= 0) {
            return;
        }
        this.unitGame.shoot(this.unitNum, this.direction);
        --this.moves;
    }

    public void damage(int amount) {
        this.health -= amount;
    }

    public void setMoves(int val) {
        this.moves = val;
    }

    public int getMoves() {
        return this.moves;
    }

    public char getDirection() {
        return this.direction;
    }

    public int getUnitNum() {
        return this.unitNum;
    }

    public int getDamageForDistance(int dist) {
        return this.damage[dist - 1];
    }

    public int getHealth() {
        return this.health;
    }
}

