/*
 * Decompiled with CFR 0.152.
 */
import java.util.Scanner;

public class MoveEmulator {
    private static String moveData = "";

    public static void record(int selected, int command) {
        moveData = String.valueOf(moveData) + selected + " " + command + " ";
    }

    public static void clear() {
        moveData = "";
    }

    public static void setData(String data) {
        moveData = data;
    }

    public static String export() {
        return moveData;
    }

    public static void play() {
        Scanner parser = new Scanner(moveData);
        while (parser.hasNextInt()) {
            int selected = parser.nextInt();
            int shftInd = parser.nextInt();
            System.out.println("Executing command: " + selected + " " + shftInd);
            GridObject test = Game.gameMap.getTrueObjectFromIndex(selected);
            if (!test.isUnit) {
                System.out.println("Error: " + test.description + " is not a unit");
                Game.gameMap.printMap();
            } else {
                System.out.println("Success: " + test.description + " is a unit");
                Game.gameMap.printMap();
            }
            Unit unit = (Unit)Game.gameMap.getTrueObjectFromIndex(selected);
            boolean moved = false;
            switch (shftInd) {
                case 0: {
                    unit.turnLeft();
                    unit.updateDescription();
                    char dir = unit.getDirection();
                    int[] coords = Game.gameMap.getCoordsFromIndex(selected);
                    Game.gameMap.updateFogofWar();
                    Main.updateMap();
                    break;
                }
                case 1: {
                    unit.turnRight();
                    unit.updateDescription();
                    char dir = unit.getDirection();
                    int[] coords = Game.gameMap.getCoordsFromIndex(selected);
                    Game.gameMap.updateFogofWar();
                    Main.updateMap();
                    break;
                }
                case 2: {
                    unit.turnAround();
                    unit.updateDescription();
                    char dir = unit.getDirection();
                    int[] coords = Game.gameMap.getCoordsFromIndex(selected);
                    Game.gameMap.updateFogofWar();
                    Main.updateMap();
                    break;
                }
                case 3: {
                    moved = unit.moveForward();
                    System.out.println("Attempted forward move: " + moved);
                    unit.updateDescription();
                    char dir = unit.getDirection();
                    int[] coords = Game.gameMap.findUnitLoc(unit.getUnitNum());
                    selected = Game.gameMap.getIndexFromCoords(coords);
                    Game.gameMap.updateFogofWar();
                    Main.updateMap();
                    break;
                }
                case 4: {
                    moved = unit.moveBackward();
                    System.out.println("Attempted backward move: " + moved);
                    unit.updateDescription();
                    char dir = unit.getDirection();
                    int[] coords = Game.gameMap.findUnitLoc(unit.getUnitNum());
                    selected = Game.gameMap.getIndexFromCoords(coords);
                    Game.gameMap.updateFogofWar();
                    Main.updateMap();
                    break;
                }
                case 5: {
                    moved = unit.moveLeft();
                    System.out.println("Attempted left move: " + moved);
                    unit.updateDescription();
                    char dir = unit.getDirection();
                    int[] coords = Game.gameMap.findUnitLoc(unit.getUnitNum());
                    selected = Game.gameMap.getIndexFromCoords(coords);
                    Game.gameMap.updateFogofWar();
                    Main.updateMap();
                    break;
                }
                case 6: {
                    moved = unit.moveRight();
                    System.out.println("Attempted right move: " + moved);
                    unit.updateDescription();
                    char dir = unit.getDirection();
                    int[] coords = Game.gameMap.findUnitLoc(unit.getUnitNum());
                    selected = Game.gameMap.getIndexFromCoords(coords);
                    Game.gameMap.updateFogofWar();
                    Main.updateMap();
                    break;
                }
                case 7: {
                    unit.shoot();
                    unit.updateDescription();
                    char dir = unit.getDirection();
                    int[] coords = Game.gameMap.findUnitLoc(unit.getUnitNum());
                    selected = Game.gameMap.getIndexFromCoords(coords);
                    Game.gameMap.updateFogofWar();
                    Main.updateMap();
                    break;
                }
                default: {
                    unit = (Unit)Game.gameMap.getTrueObjectFromIndex(selected);
                }
            }
        }
    }
}

