/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Main {
    public static MyFrame frame;
    public static JButton[][] buttons;
    public static JButton[] interButtons;
    public static JComboBox[] squadBoxes;
    public static JComboBox serverBox;
    public static JTextField text;
    public static int numberOfSquares;
    public static String description;
    public static JLabel desc;
    public static int selected;
    public static ImageIcon[] mapIcons;
    public static ImageIcon[] interfaceIcons;
    public static String[] interfaceTooltips;
    public static CustomActionListener[][] mapListeners;
    public static CustomActionListener[] interListeners;

    static {
        interButtons = new JButton[9];
        mapIcons = new ImageIcon[]{new ImageIcon("resources/playernorth.PNG"), new ImageIcon("resources/playereast.PNG"), new ImageIcon("resources/playersouth.PNG"), new ImageIcon("resources/playerwest.PNG"), new ImageIcon("resources/wall.PNG"), new ImageIcon("resources/ground.PNG"), new ImageIcon("resources/trench.PNG"), new ImageIcon("resources/lowwall.PNG"), new ImageIcon("resources/black.PNG"), new ImageIcon("resources/playernorth2.PNG"), new ImageIcon("resources/playereast2.PNG"), new ImageIcon("resources/playersouth2.PNG"), new ImageIcon("resources/playerwest2.PNG"), new ImageIcon("resources/shotvert.PNG"), new ImageIcon("resources/shothoriz.PNG")};
        interfaceIcons = new ImageIcon[]{new ImageIcon("resources/turnleft.PNG"), new ImageIcon("resources/turnright.PNG"), new ImageIcon("resources/turnaround.PNG"), new ImageIcon("resources/moveforward.PNG"), new ImageIcon("resources/movebackward.PNG"), new ImageIcon("resources/moveleft.PNG"), new ImageIcon("resources/moveright.PNG"), new ImageIcon("resources/attack.PNG"), new ImageIcon("resources/endturn.PNG")};
        interfaceTooltips = new String[]{"Turn left (No move cost)", "Turn right (No move cost)", "Turn around (No move cost)", "Move forward (Costs 1 move)", "Move backward (Costs 1 move)", "Strafe left (Costs 1 move)", "Strafe right (Costs 1 move)", "Attack (Costs 1 move)", "End turn"};
        interListeners = new CustomActionListener[9];
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.initGame();
            }
        });
    }

    public static void initGame() {
        frame = new MyFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(450, 450);
        frame.setVisible(true);
        JPanel pan = new JPanel();
        pan.setLayout(new GridLayout(0, 1));
        squadBoxes = new JComboBox[4];
        int i = 0;
        while (i < squadBoxes.length) {
            Main.squadBoxes[i] = new JComboBox();
            squadBoxes[i].addItem("Sniper");
            squadBoxes[i].addItem("Assault");
            squadBoxes[i].addItem("Shotgunner");
            ++i;
        }
        serverBox = new JComboBox();
        serverBox.addItem("Server");
        serverBox.addItem("Client");
        pan.add(new JLabel("Welcome to this experiment!"));
        pan.add(new JLabel("This is an attempt at creating a Turn Based Strategy (TBS) game."));
        pan.add(new JLabel("You must choose the four members of your squad."));
        pan.add(new JLabel("You have three class choices:"));
        pan.add(new JLabel("Sniper, Assault, and Shotgunner."));
        pan.add(new JLabel("Choose wisely."));
        i = 0;
        while (i < squadBoxes.length) {
            pan.add(squadBoxes[i]);
            ++i;
        }
        pan.add(new JLabel("Now, do you want to host and be a server, or connect to a server and be a client?"));
        pan.add(serverBox);
        pan.add(new JLabel("This field is only used for a client: what is the IP of the server?"));
        text = new JTextField();
        pan.add(text);
        JButton submitter = new JButton("Begin");
        pan.add(submitter);
        ActionListener listen = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                String[] classes = new String[8];
                boolean offset = false;
                String ip = text.getText();
                if (serverBox.getSelectedItem().equals("Server")) {
                    int i = 0;
                    while (i < 4) {
                        classes[i] = squadBoxes[i].getSelectedItem().toString();
                        ++i;
                    }
                    Game.player1View = true;
                    ConnectionHandler con = new ConnectionHandler(true, ip);
                    con.start();
                    AsyncConnectionHandler acon = new AsyncConnectionHandler(true, ip);
                    acon.start();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    i = 0;
                    while (i < 4) {
                        classes[i + 4] = ConnectionHandler.receiveData();
                        System.out.println("Server retrieved class " + i + " " + classes[i + 4]);
                        System.out.println("Server now sending class" + i + " " + classes[i]);
                        ConnectionHandler.sendData(classes[i]);
                        ++i;
                    }
                    System.out.println("Initial transfer complete");
                } else {
                    int i = 0;
                    while (i < 4) {
                        classes[i + 4] = squadBoxes[i].getSelectedItem().toString();
                        ++i;
                    }
                    Game.player1View = false;
                    ConnectionHandler con = new ConnectionHandler(false, ip);
                    con.start();
                    AsyncConnectionHandler acon = new AsyncConnectionHandler(false, ip);
                    acon.start();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    i = 0;
                    while (i < 4) {
                        System.out.println("Client sending class" + i + " " + classes[i + 4]);
                        ConnectionHandler.sendData(classes[i + 4]);
                        classes[i] = ConnectionHandler.receiveData();
                        System.out.println("Client retrieved class " + i + " " + classes[i]);
                        ++i;
                    }
                    System.out.println("Initial transfer complete");
                }
                Main.initMap(classes);
            }
        };
        submitter.addActionListener(listen);
        frame.add(pan);
    }

    public static void initMap(String[] classes) {
        int j;
        Game gm;
        ChatManager chatty = new ChatManager();
        chatty.initialize();
        if (ConnectionHandler.server) {
            gm = new Game("generate", classes);
            ConnectionHandler.receiveData();
            ConnectionHandler.sendData(Game.gameMap.exportMap());
        } else {
            ConnectionHandler.sendData("garbage");
            String mapData = ConnectionHandler.receiveData();
            gm = new Game(mapData, classes);
        }
        numberOfSquares = 15;
        mapListeners = new CustomActionListener[numberOfSquares][numberOfSquares];
        buttons = new JButton[numberOfSquares][numberOfSquares];
        frame = new MyFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(numberOfSquares * 32, numberOfSquares * 32 + 64);
        JPanel panel = new JPanel();
        GridLayout grid = new GridLayout(numberOfSquares, numberOfSquares);
        panel.setLayout(grid);
        System.out.println(panel.toString());
        int indexCounter = 0;
        int i = 0;
        while (i < numberOfSquares) {
            j = 0;
            while (j < numberOfSquares) {
                Main.mapListeners[i][j] = new CustomActionListener(indexCounter);
                ++indexCounter;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < numberOfSquares) {
            j = 0;
            while (j < numberOfSquares) {
                JButton button = new JButton();
                button.setContentAreaFilled(false);
                button.setBorderPainted(false);
                Main.buttons[i][j] = button;
                panel.add(button);
                button.addActionListener(mapListeners[i][j]);
                ++j;
            }
            ++i;
        }
        Main.updateMap();
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(1, 0));
        desc = new JLabel(description);
        panel2.add(desc);
        CustomActionListener.interfaceIndex = indexCounter;
        int i2 = 0;
        while (i2 < interListeners.length) {
            Main.interListeners[i2] = new CustomActionListener(indexCounter);
            ++indexCounter;
            ++i2;
        }
        i2 = 0;
        while (i2 < interfaceIcons.length) {
            Main.interButtons[i2] = new JButton();
            interButtons[i2].setIcon(interfaceIcons[i2]);
            interButtons[i2].setContentAreaFilled(false);
            interButtons[i2].setBorderPainted(false);
            interButtons[i2].addActionListener(interListeners[i2]);
            interButtons[i2].setEnabled(false);
            interButtons[i2].setToolTipText(interfaceTooltips[i2]);
            panel2.add(interButtons[i2]);
            ++i2;
        }
        frame.add(panel);
        frame.add((Component)panel2, "South");
        frame.setVisible(true);
        Thread firstMove = new Thread(){

            @Override
            public void run() {
                if (!ConnectionHandler.server) {
                    MyFrame popup = new MyFrame();
                    popup.setSize(512, 64);
                    popup.setLocationByPlatform(true);
                    popup.add(new JLabel("The server goes first.  Please wait while your opponent moves."));
                    popup.setDefaultCloseOperation(0);
                    Main.disableButtons();
                    popup.setVisible(true);
                    ConnectionHandler.sendData("garbage");
                    String moves = ConnectionHandler.receiveData();
                    MoveEmulator.setData(moves);
                    MoveEmulator.play();
                    MoveEmulator.clear();
                    popup.dispose();
                    Game.player1Turn = !Game.player1Turn;
                } else {
                    ConnectionHandler.receiveData();
                }
            }
        };
        firstMove.start();
    }

    public static void updateMap() {
        int i = 0;
        while (i < numberOfSquares) {
            int j = 0;
            while (j < numberOfSquares) {
                char dir;
                Unit unit;
                GridObject obj = Game.gameMap.getObjectFromCoord(i, j);
                char image = Game.gameMap.getLoc(i, j);
                if (image == 'W') {
                    buttons[i][j].setIcon(mapIcons[4]);
                } else if (image >= '1' && image <= '4') {
                    unit = (Unit)Game.gameMap.getObjectFromCoord(i, j);
                    dir = unit.getDirection();
                    switch (dir) {
                        case 'n': {
                            buttons[i][j].setIcon(mapIcons[0]);
                            break;
                        }
                        case 'e': {
                            buttons[i][j].setIcon(mapIcons[1]);
                            break;
                        }
                        case 's': {
                            buttons[i][j].setIcon(mapIcons[2]);
                            break;
                        }
                        case 'w': {
                            buttons[i][j].setIcon(mapIcons[3]);
                        }
                    }
                } else if (image >= '5' && image <= '8') {
                    unit = (Unit)Game.gameMap.getObjectFromCoord(i, j);
                    dir = unit.getDirection();
                    switch (dir) {
                        case 'n': {
                            buttons[i][j].setIcon(mapIcons[9]);
                            break;
                        }
                        case 'e': {
                            buttons[i][j].setIcon(mapIcons[10]);
                            break;
                        }
                        case 's': {
                            buttons[i][j].setIcon(mapIcons[11]);
                            break;
                        }
                        case 'w': {
                            buttons[i][j].setIcon(mapIcons[12]);
                        }
                    }
                } else if (image == 'T') {
                    buttons[i][j].setIcon(mapIcons[6]);
                } else if (image == 'L') {
                    buttons[i][j].setIcon(mapIcons[7]);
                } else if (image == 'X') {
                    buttons[i][j].setIcon(mapIcons[8]);
                } else if (image >= '\u0000' && image < '\n') {
                    buttons[i][j].setIcon(mapIcons[13]);
                } else if (image >= '\n' && image < '\u0014') {
                    buttons[i][j].setIcon(mapIcons[14]);
                } else {
                    buttons[i][j].setIcon(mapIcons[5]);
                }
                buttons[i][j].setToolTipText(obj.toString());
                ++j;
            }
            ++i;
        }
    }

    public static void disableButtons() {
        int i = 0;
        while (i < interButtons.length) {
            interButtons[i].setEnabled(false);
            ++i;
        }
    }

    public static void enableButtons() {
        int i = 0;
        while (i < interButtons.length) {
            interButtons[i].setEnabled(true);
            ++i;
        }
    }
}

