/*
 * Decompiled with CFR 0.152.
 */
import java.util.Scanner;

public class Map {
    public static final char GROUND = '.';
    public static final char WALL = 'W';
    public static final char LOWWALL = 'L';
    public static final char STAIRN = 'N';
    public static final char STAIRS = 'S';
    public static final char STAIRE = 'E';
    public static final char STAIRW = 'W';
    public static final char FLOOR = 'F';
    public static final char TRENCH = 'T';
    public static final char NULLSPACE = '0';
    public static final char BLACK = 'X';
    public static final char SPAWN1 = '1';
    public static final char SPAWN2 = '2';
    public static final char SPAWN3 = '3';
    public static final char SPAWN4 = '4';
    public static final char SPAWN5 = '5';
    public static final char SPAWN6 = '6';
    public static final char SPAWN7 = '7';
    public static final char SPAWN8 = '8';
    private char[][] map;
    private char[][] mapOverlay;
    private char[][] mapFOW;

    public Map(int mapSize) {
        this.map = new char[mapSize][mapSize];
        this.mapOverlay = new char[mapSize][mapSize];
        this.mapFOW = new char[mapSize][mapSize];
    }

    public void genMap() {
        int len = this.map.length;
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < len) {
                int randomizer = (int)(Math.random() * 10.0);
                switch (randomizer) {
                    case 0: {
                        this.map[i][j] = 46;
                        break;
                    }
                    case 1: {
                        this.map[i][j] = 46;
                        break;
                    }
                    case 2: {
                        this.map[i][j] = 87;
                        break;
                    }
                    case 3: {
                        this.map[i][j] = 76;
                        break;
                    }
                    case 4: {
                        this.map[i][j] = 84;
                        break;
                    }
                    default: {
                        this.map[i][j] = 46;
                    }
                }
                this.mapOverlay[i][j] = 48;
                this.mapFOW[i][j] = 48;
                ++j;
            }
            ++i;
        }
        this.map[0][0] = 46;
        this.map[0][1] = 46;
        this.map[1][0] = 46;
        this.map[1][1] = 46;
        this.map[len - 1][len - 1] = 46;
        this.map[len - 1][len - 2] = 46;
        this.map[len - 2][len - 1] = 46;
        this.map[len - 2][len - 2] = 46;
        this.mapOverlay[0][0] = 49;
        this.mapOverlay[0][1] = 50;
        this.mapOverlay[1][0] = 51;
        this.mapOverlay[1][1] = 52;
        this.mapOverlay[len - 1][len - 1] = 53;
        this.mapOverlay[len - 1][len - 2] = 54;
        this.mapOverlay[len - 2][len - 1] = 55;
        this.mapOverlay[len - 2][len - 2] = 56;
    }

    public String exportMap() {
        int len = this.map.length;
        String answer = "" + len;
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < len) {
                answer = String.valueOf(answer) + " " + this.getTrueLoc(i, j);
                ++j;
            }
            ++i;
        }
        return answer;
    }

    public void importMap(String data) {
        Scanner parser = new Scanner(data);
        parser.next();
        int len = this.map.length;
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < len) {
                char nextChar = parser.next().charAt(0);
                if (nextChar >= '1' && nextChar <= '8') {
                    this.map[i][j] = 46;
                    this.mapOverlay[i][j] = nextChar;
                    this.mapFOW[i][j] = 48;
                } else {
                    this.map[i][j] = nextChar;
                    this.mapOverlay[i][j] = 48;
                }
                this.mapFOW[i][j] = 48;
                ++j;
            }
            ++i;
        }
    }

    public int checkVictory() {
        int[] unitLoc;
        int numDead = 0;
        int i = 1;
        while (i <= 4) {
            unitLoc = this.findUnitLoc(i);
            if (unitLoc == null) {
                ++numDead;
            }
            ++i;
        }
        if (numDead == 4) {
            return 1;
        }
        numDead = 0;
        i = 5;
        while (i <= 8) {
            unitLoc = this.findUnitLoc(i);
            if (unitLoc == null) {
                ++numDead;
            }
            ++i;
        }
        if (numDead == 4) {
            return 2;
        }
        return -1;
    }

    public void resetUnitMoves(int val) {
        int i = 1;
        while (i <= 8) {
            int[] unitLoc = this.findUnitLoc(i);
            if (unitLoc != null) {
                Unit unit = (Unit)this.getTrueObjectFromCoord(unitLoc[0], unitLoc[1]);
                unit.setMoves(val);
            }
            ++i;
        }
    }

    public void updateFogofWar() {
        int len = this.map.length;
        if (Game.player1View) {
            int i = 0;
            while (i < len) {
                int j = 0;
                while (j < len) {
                    this.mapFOW[i][j] = this.withinRangePlayer1(i, j) ? 48 : 88;
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                int j = 0;
                while (j < len) {
                    this.mapFOW[i][j] = this.withinRangePlayer2(i, j) ? 48 : 88;
                    ++j;
                }
                ++i;
            }
        }
    }

    public boolean withinRangePlayer1(int row, int col) {
        int i = 1;
        while (i <= 4) {
            int[] unitLoc = this.findUnitLoc(i);
            if (unitLoc != null) {
                Unit unit = (Unit)this.getObjectFromCoord(unitLoc[0], unitLoc[1]);
                char dir = unit.getDirection();
                int offset = -1;
                int secondaryOffset = -1;
                if (dir == 'n') {
                    offset = -1;
                    while (offset <= 6) {
                        secondaryOffset = -1;
                        while (secondaryOffset <= 1) {
                            if (!this.outOfBounds(unitLoc[0] - offset, unitLoc[1] + secondaryOffset) && unitLoc[0] - offset == row && unitLoc[1] + secondaryOffset == col) {
                                return true;
                            }
                            ++secondaryOffset;
                        }
                        ++offset;
                    }
                }
                if (dir == 'e') {
                    offset = -1;
                    while (offset <= 6) {
                        secondaryOffset = -1;
                        while (secondaryOffset <= 1) {
                            if (!this.outOfBounds(unitLoc[0] + secondaryOffset, unitLoc[1] + offset) && unitLoc[0] + secondaryOffset == row && unitLoc[1] + offset == col) {
                                return true;
                            }
                            ++secondaryOffset;
                        }
                        ++offset;
                    }
                }
                if (dir == 's') {
                    offset = -1;
                    while (offset <= 6) {
                        secondaryOffset = -1;
                        while (secondaryOffset <= 1) {
                            if (!this.outOfBounds(unitLoc[0] + offset, unitLoc[1] - secondaryOffset) && unitLoc[0] + offset == row && unitLoc[1] - secondaryOffset == col) {
                                return true;
                            }
                            ++secondaryOffset;
                        }
                        ++offset;
                    }
                }
                if (dir == 'w') {
                    offset = -1;
                    while (offset <= 6) {
                        secondaryOffset = -1;
                        while (secondaryOffset <= 1) {
                            if (!this.outOfBounds(unitLoc[0] - secondaryOffset, unitLoc[1] - offset) && unitLoc[0] - secondaryOffset == row && unitLoc[1] - offset == col) {
                                return true;
                            }
                            ++secondaryOffset;
                        }
                        ++offset;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public boolean withinRangePlayer2(int row, int col) {
        int i = 5;
        while (i <= 8) {
            int[] unitLoc = this.findUnitLoc(i);
            if (unitLoc != null) {
                Unit unit = (Unit)this.getObjectFromCoord(unitLoc[0], unitLoc[1]);
                char dir = unit.getDirection();
                int offset = -1;
                int secondaryOffset = -1;
                if (dir == 'n') {
                    offset = -1;
                    while (offset <= 6) {
                        secondaryOffset = -1;
                        while (secondaryOffset <= 1) {
                            if (!this.outOfBounds(unitLoc[0] - offset, unitLoc[1] + secondaryOffset) && unitLoc[0] - offset == row && unitLoc[1] + secondaryOffset == col) {
                                return true;
                            }
                            ++secondaryOffset;
                        }
                        ++offset;
                    }
                }
                if (dir == 'e') {
                    offset = -1;
                    while (offset <= 6) {
                        secondaryOffset = -1;
                        while (secondaryOffset <= 1) {
                            if (!this.outOfBounds(unitLoc[0] + secondaryOffset, unitLoc[1] + offset) && unitLoc[0] + secondaryOffset == row && unitLoc[1] + offset == col) {
                                return true;
                            }
                            ++secondaryOffset;
                        }
                        ++offset;
                    }
                }
                if (dir == 's') {
                    offset = -1;
                    while (offset <= 6) {
                        secondaryOffset = -1;
                        while (secondaryOffset <= 1) {
                            if (!this.outOfBounds(unitLoc[0] + offset, unitLoc[1] - secondaryOffset) && unitLoc[0] + offset == row && unitLoc[1] - secondaryOffset == col) {
                                return true;
                            }
                            ++secondaryOffset;
                        }
                        ++offset;
                    }
                }
                if (dir == 'w') {
                    offset = -1;
                    while (offset <= 6) {
                        secondaryOffset = -1;
                        while (secondaryOffset <= 1) {
                            if (!this.outOfBounds(unitLoc[0] - secondaryOffset, unitLoc[1] - offset) && unitLoc[0] - secondaryOffset == row && unitLoc[1] - offset == col) {
                                return true;
                            }
                            ++secondaryOffset;
                        }
                        ++offset;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public boolean outOfBounds(int row, int col) {
        int len = this.map.length;
        if (row < 0 || row >= len) {
            return true;
        }
        return col < 0 || col >= len;
    }

    public void printMap() {
        int i = 0;
        while (i < this.map.length) {
            int j = 0;
            while (j < this.map.length) {
                if (this.mapOverlay[i][j] == '0') {
                    System.out.print(this.map[i][j]);
                } else {
                    System.out.print(this.mapOverlay[i][j]);
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public boolean moveUnit(int unitNum, char dir) {
        int[] unitLoc = this.findUnitLoc(unitNum);
        if (unitLoc == null) {
            System.out.println("Null unit location when attempting to move unit " + unitNum);
            return false;
        }
        if (dir == 'n') {
            if (unitLoc[0] > 0 && this.map[unitLoc[0] - 1][unitLoc[1]] == '.' && (this.mapOverlay[unitLoc[0] - 1][unitLoc[1]] == '0' || this.mapOverlay[unitLoc[0] - 1][unitLoc[1]] < '\u0014')) {
                this.mapOverlay[unitLoc[0]][unitLoc[1]] = 48;
                this.mapOverlay[unitLoc[0] - 1][unitLoc[1]] = (char)(48 + unitNum);
                return true;
            }
        } else if (dir == 'e') {
            if (unitLoc[1] + 1 < this.map.length && this.map[unitLoc[0]][unitLoc[1] + 1] == '.' && (this.mapOverlay[unitLoc[0]][unitLoc[1] + 1] == '0' || this.mapOverlay[unitLoc[0]][unitLoc[1] + 1] < '\u0014')) {
                this.mapOverlay[unitLoc[0]][unitLoc[1]] = 48;
                this.mapOverlay[unitLoc[0]][unitLoc[1] + 1] = (char)(48 + unitNum);
                return true;
            }
        } else if (dir == 's') {
            if (unitLoc[0] + 1 < this.map.length && this.map[unitLoc[0] + 1][unitLoc[1]] == '.' && (this.mapOverlay[unitLoc[0] + 1][unitLoc[1]] == '0' || this.mapOverlay[unitLoc[0] + 1][unitLoc[1]] < '\u0014')) {
                this.mapOverlay[unitLoc[0]][unitLoc[1]] = 48;
                this.mapOverlay[unitLoc[0] + 1][unitLoc[1]] = (char)(48 + unitNum);
                return true;
            }
        } else if (unitLoc[1] > 0 && this.map[unitLoc[0]][unitLoc[1] - 1] == '.' && (this.mapOverlay[unitLoc[0]][unitLoc[1] - 1] == '0' || this.mapOverlay[unitLoc[0]][unitLoc[1] - 1] < '\u0014')) {
            this.mapOverlay[unitLoc[0]][unitLoc[1]] = 48;
            this.mapOverlay[unitLoc[0]][unitLoc[1] - 1] = (char)(48 + unitNum);
            return true;
        }
        return false;
    }

    public boolean moveUnitBack(int unitNum, char dir) {
        if (dir == 'n') {
            dir = (char)115;
        } else if (dir == 's') {
            dir = (char)110;
        } else if (dir == 'e') {
            dir = (char)119;
        } else if (dir == 'w') {
            dir = (char)101;
        }
        return this.moveUnit(unitNum, dir);
    }

    public boolean moveUnitLeft(int unitNum, char dir) {
        if (dir == 'n') {
            dir = (char)119;
        } else if (dir == 's') {
            dir = (char)101;
        } else if (dir == 'e') {
            dir = (char)110;
        } else if (dir == 'w') {
            dir = (char)115;
        }
        return this.moveUnit(unitNum, dir);
    }

    public boolean moveUnitRight(int unitNum, char dir) {
        if (dir == 'n') {
            dir = (char)101;
        } else if (dir == 's') {
            dir = (char)119;
        } else if (dir == 'e') {
            dir = (char)115;
        } else if (dir == 'w') {
            dir = (char)110;
        }
        return this.moveUnit(unitNum, dir);
    }

    public void unitShoot(int unitNum, char dir) {
        int[] unitLoc = this.findUnitLoc(unitNum);
        if (unitLoc == null) {
            System.out.println("Null unit location when attempting to move unit " + unitNum);
            return;
        }
        Unit unit = (Unit)this.getTrueObjectFromCoord(unitLoc[0], unitLoc[1]);
        int damReduce = 0;
        int i = 1;
        while (i <= 6) {
            Unit unit2;
            char mapData;
            int damage = unit.getDamageForDistance(i);
            if (dir == 'n' && !this.outOfBounds(unitLoc[0] - i, unitLoc[1])) {
                mapData = this.getTrueLoc(unitLoc[0] - i, unitLoc[1]);
                if (mapData == '.' || mapData < '\u0014') {
                    if ((damage -= damReduce) < 0) {
                        damage = 0;
                    }
                    this.mapOverlay[unitLoc[0] - i][unitLoc[1]] = (char)damage;
                    damReduce = 0;
                } else if (mapData == 'L') {
                    damReduce = 2;
                } else {
                    if (mapData < '1' || mapData > '8') break;
                    unit2 = (Unit)this.getTrueObjectFromCoord(unitLoc[0] - i, unitLoc[1]);
                    unit2.damage(damage);
                    unit2.updateDescription();
                    if (unit2.getHealth() <= 0) {
                        this.mapOverlay[unitLoc[0] - i][unitLoc[1]] = (char)damage;
                    }
                    damReduce = 0;
                }
            }
            if (dir == 'e' && !this.outOfBounds(unitLoc[0], unitLoc[1] + i)) {
                mapData = this.getLoc(unitLoc[0], unitLoc[1] + i);
                if (mapData == '.' || mapData < '\u0014') {
                    if ((damage -= damReduce) < 0) {
                        damage = 0;
                    }
                    this.mapOverlay[unitLoc[0]][unitLoc[1] + i] = (char)(damage + 10);
                    damReduce = 0;
                } else if (mapData == 'L') {
                    damReduce = 2;
                } else {
                    if (mapData < '1' || mapData > '8') break;
                    unit2 = (Unit)this.getObjectFromCoord(unitLoc[0], unitLoc[1] + i);
                    unit2.damage(damage);
                    unit2.updateDescription();
                    if (unit2.getHealth() <= 0) {
                        this.mapOverlay[unitLoc[0]][unitLoc[1] + i] = (char)damage;
                    }
                    damReduce = 0;
                }
            }
            if (dir == 's' && !this.outOfBounds(unitLoc[0] + i, unitLoc[1])) {
                mapData = this.getLoc(unitLoc[0] + i, unitLoc[1]);
                if (mapData == '.' || mapData < '\u0014') {
                    if ((damage -= damReduce) < 0) {
                        damage = 0;
                    }
                    this.mapOverlay[unitLoc[0] + i][unitLoc[1]] = (char)damage;
                    damReduce = 0;
                } else if (mapData == 'L') {
                    damReduce = 2;
                } else {
                    if (mapData < '1' || mapData > '8') break;
                    unit2 = (Unit)this.getObjectFromCoord(unitLoc[0] + i, unitLoc[1]);
                    unit2.damage(damage);
                    unit2.updateDescription();
                    if (unit2.getHealth() <= 0) {
                        this.mapOverlay[unitLoc[0] + i][unitLoc[1]] = (char)damage;
                    }
                    damReduce = 0;
                }
            }
            if (dir == 'w' && !this.outOfBounds(unitLoc[0], unitLoc[1] - i)) {
                mapData = this.getLoc(unitLoc[0], unitLoc[1] - i);
                if (mapData == '.' || mapData < '\u0014') {
                    if ((damage -= damReduce) < 0) {
                        damage = 0;
                    }
                    this.mapOverlay[unitLoc[0]][unitLoc[1] - i] = (char)(damage + 10);
                    damReduce = 0;
                } else if (mapData == 'L') {
                    damReduce = 2;
                } else {
                    if (mapData < '1' || mapData > '8') break;
                    unit2 = (Unit)this.getObjectFromCoord(unitLoc[0], unitLoc[1] - i);
                    unit2.damage(damage);
                    unit2.updateDescription();
                    if (unit2.getHealth() <= 0) {
                        this.mapOverlay[unitLoc[0]][unitLoc[1] - i] = (char)damage;
                    }
                    damReduce = 0;
                }
            }
            ++i;
        }
    }

    public int[] findUnitLoc(int unitNum) {
        unitNum += 48;
        int[] locs = new int[2];
        int i = 0;
        while (i < this.map.length) {
            int j = 0;
            while (j < this.map.length) {
                if (this.mapOverlay[i][j] == unitNum) {
                    locs[0] = i;
                    locs[1] = j;
                    return locs;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private char getTrueLoc(int row, int col) {
        if (this.mapOverlay[row][col] == '0') {
            return this.map[row][col];
        }
        return this.mapOverlay[row][col];
    }

    public char getLoc(int row, int col) {
        if (this.mapFOW[row][col] == 'X') {
            return 'X';
        }
        if (this.mapOverlay[row][col] == '0') {
            return this.map[row][col];
        }
        return this.mapOverlay[row][col];
    }

    public int[] getCoordsFromIndex(int indx) {
        int incIndx = 0;
        int[] result = new int[2];
        int i = 0;
        while (i < this.map.length) {
            int j = 0;
            while (j < this.map.length) {
                result[0] = i;
                result[1] = j++;
                if (incIndx == indx) {
                    return result;
                }
                ++incIndx;
            }
            ++i;
        }
        return null;
    }

    public int getIndexFromCoords(int[] coords) {
        int incIndx = 0;
        int i = 0;
        while (i < this.map.length) {
            int j = 0;
            while (j < this.map.length) {
                if (i == coords[0] && j == coords[1]) {
                    return incIndx;
                }
                ++incIndx;
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public GridObject getObjectFromCoord(int row, int col) {
        char type = this.getLoc(row, col);
        if (type >= '1' && type <= '8') {
            Unit unit = Game.units[type - 49];
            unit.updateDescription();
            return unit;
        }
        if (type == 'W') {
            return new GridObject("Wall");
        }
        if (type == 'L') {
            return new GridObject("Low wall");
        }
        if (type == 'T') {
            return new GridObject("Trench");
        }
        if (type == 'X') {
            return new GridObject("Unknown");
        }
        if (type >= '\u0000' && type < '\n') {
            return new GridObject(type + " damage");
        }
        if (type >= '\n' && type < '\u0014') {
            return new GridObject(type - 10 + " damage");
        }
        return new GridObject("Ground");
    }

    public GridObject getObjectFromIndex(int indx) {
        int[] location = this.getCoordsFromIndex(indx);
        return this.getObjectFromCoord(location[0], location[1]);
    }

    public GridObject getTrueObjectFromCoord(int row, int col) {
        char type = this.getTrueLoc(row, col);
        if (type >= '1' && type <= '8') {
            Unit unit = Game.units[type - 49];
            unit.updateDescription();
            return unit;
        }
        if (type == 'W') {
            return new GridObject("Wall");
        }
        if (type == 'L') {
            return new GridObject("Low wall");
        }
        if (type == 'T') {
            return new GridObject("Trench");
        }
        if (type == 'X') {
            return new GridObject("Unknown");
        }
        if (type >= '\u0000' && type < '\n') {
            return new GridObject(type + " damage");
        }
        if (type >= '\n' && type < '\u0014') {
            return new GridObject(type - 10 + " damage");
        }
        return new GridObject("Ground");
    }

    public GridObject getTrueObjectFromIndex(int indx) {
        int[] location = this.getCoordsFromIndex(indx);
        return this.getTrueObjectFromCoord(location[0], location[1]);
    }
}

